#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
uint8_t half;
uint8_t reg;

void sync (void) {
	EMU->SetPRG_ROM16(0x8, half <<5 &0x20 | reg <<3 &0x18 | Latch::data &0x07);
	EMU->SetPRG_ROM16(0xC, half <<5 &0x20 | reg <<3 &0x18 | 0x07);
	iNES_SetCHR_Auto8(0x0, 0);
	if (reg &0x04)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

BOOL MAPINT load (void) {
	Latch::load(sync, NULL);
	return TRUE;
}

void MAPINT writeReg (int, int, int val) {
	reg = val;
	sync();
}

void MAPINT reset (RESET_TYPE resetType) {
	EMU->GetCPUWriteHandler(0x0)(0x0, 0x100, 0x00);
	half = resetType == RESET_HARD? 0: !half;
	reg = 0;
	Latch::reset(RESET_HARD);
	EMU->SetCPUWriteHandler(0x5, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset = Latch::saveLoad_D(stateMode, offset, data);
	SAVELOAD_BYTE(stateMode, offset, data, half);
	SAVELOAD_BYTE(stateMode, offset, data, reg);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 301;
} // namespace

MapperInfo MapperInfo_301 = {
	&mapperNum,
	_T("K-3003"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};